package gov.va.med.mhv.sm.admin.jpa.model;

import java.util.Date;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.SelectBeforeUpdate;
import org.hibernate.annotations.Type;
import com.fasterxml.jackson.annotation.JsonFormat;
import gov.va.med.mhv.sm.admin.jpa.model.AbstractBaseEntity;
import gov.va.med.mhv.sm.admin.data.enums.ParticipantTypeEnum;

@Entity
@Table(name = "TRIAGE_GROUP")
@DynamicUpdate(value = true)
@SelectBeforeUpdate(value = true)
public class TriageGroup extends AbstractBaseEntity {

	private static final long serialVersionUID = 392892578015539902L;

	@Id
	@Column(name = "TRIAGE_GROUP_ID")
	@GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "sequence")
	@SequenceGenerator(name = "sequence", sequenceName = "GEN_SMS_SEQ")
	private Long id;

	@Column(name = "ACTIVE", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean active;

	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "EEE, dd MMM yyyy HH:mm:ss z")
	@Column(name = "CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;

	@Column(name = "DESCRIPTION")
	private String description;

	@Column(name = "MODIFIED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date modifiedDate;

	@Column(name = "TRIAGE_GROUP_NAME")
	private String name;

	@Version
	@Column(name = "OPLOCK")
	private Integer oplock;

	@OneToMany(mappedBy="triageGroup",cascade=CascadeType.ALL,orphanRemoval=true)
	private Set<TriageRelation> relations;
	
	@OneToMany(mappedBy="triageGroup",cascade=CascadeType.ALL,orphanRemoval=true)
	private Set<ClinicianTriageMap> clinicianTriageMaps;
	

	@Column(name = "VISTA_DIV")
	private String vistaDiv;

	public TriageGroup() {
		this.active = true;
		this.createdDate = new Date();
		this.modifiedDate = new Date();
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Boolean getActive() {
		return active;
	}

	public void setActive(Boolean active) {
		this.active = active;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Set<TriageRelation> getRelations() {
		return relations;
	}

	public void setRelations(Set<TriageRelation> relations) {
		this.relations = relations;
	}

	public String getVistaDiv() {
		return vistaDiv;
	}

	public void setVistaDiv(String vistaDiv) {
		this.vistaDiv = vistaDiv;
	}

	public void addRelation(TriageRelation tr) {
		tr.setTriageGroup(this);
		this.getRelations().add(tr);
	}

	public void removeRelation(TriageRelation tr) {
		tr.setTriageGroup(null);
		getRelations().remove(tr);
	}

	public ParticipantTypeEnum getParticipantType() {
		return ParticipantTypeEnum.TRIAGE_GROUP;
	}
	
	public Set<ClinicianTriageMap> getClinicianTriageMaps() {
		return clinicianTriageMaps;
	}

	public void setClinicianTriageMaps(Set<ClinicianTriageMap> clinicianTriageMaps) {
		this.clinicianTriageMaps = clinicianTriageMaps;
	}

	public void addClinicianTriageMap(ClinicianTriageMap ctm) {
		ctm.setTriageGroup(this);
		getClinicianTriageMaps().add(ctm);
	}
	
	public void removeClinicianTriageMap(ClinicianTriageMap ctm) {
		ctm.setTriageGroup(null);
		getClinicianTriageMaps().remove(ctm);
	}


}
